/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;

public final class CallContext
implements CallInfo {
    private final long contextAddress;
    private volatile boolean disposed = false;
    private final int parameterCount;
    private final int rawParameterSize;
    private final Type returnType;
    private final Type[] parameterTypes;

    public CallContext(Type type, Type ... typeArray) {
        this(type, typeArray, CallingConvention.DEFAULT, true);
    }

    public CallContext(Type type, Type[] typeArray, CallingConvention callingConvention) {
        this(type, typeArray, callingConvention, true);
    }

    public CallContext(Type type, Type[] typeArray, CallingConvention callingConvention, boolean bl) {
        int n = (!bl ? 2 : 0) | (callingConvention == CallingConvention.STDCALL ? 1 : 0);
        long l = Foreign.getInstance().newCallContext(type.handle(), Type.nativeHandles(typeArray), n);
        if (l == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = l;
        this.returnType = type;
        this.parameterTypes = (Type[])typeArray.clone();
        this.parameterCount = typeArray.length;
        this.rawParameterSize = Foreign.getInstance().getFunctionRawParameterSize(l);
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getAddress() {
        return this.contextAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int n) {
        return this.parameterTypes[n];
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("context already freed");
        }
        Foreign.getInstance().freeCallContext(this.contextAddress);
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L && !this.disposed) {
                Foreign.getInstance().freeCallContext(this.contextAddress);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            super.finalize();
        }
    }
}

